%{
Copyright (c) 2011, MIT.
Developed with the sponsorship of the Defense Advanced Research Projects
Agency (DARPA).

Permission is hereby granted, free of charge, to any person obtaining a copy
of this data, including any software or models in source or binary form, as
well as any drawings, specifications, and documentation (collectively "the
Data"), to deal in the Data without restriction, including without
limitation the rights to use, copy, modify, merge, publish, distribute,
sublicense, and/or sell copies of the Data, and to permit persons to whom
the Data is furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Data.

THE DATA IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS, SPONSORS, DEVELOPERS, CONTRIBUTORS, OR COPYRIGHT HOLDERS BE LIABLE
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE DATA OR
THE USE OR OTHER DEALINGS IN THE DATA.
%}

% DMExp Loader
function [numRules,totalDesigns,numEpochs,numAtt,MAU,SAU,Tcost,Ttime,allCostPaths,allDesignPaths,allRulePaths,FCOST,AttWeights] = dataLoader(a,b,c,d,T,TC)


% now read in the MATE study
load(a) % DMexpA
load(b) % DMexpB
load(c) % DMexpC
load(d) % DMexpD
load(T) % Trans matrices
load(TC) % collapsed trans matrices

% Utilities
% MAU column vectors, placed in same matrix
%(i,j) --> i = design, j = epoch
MAU = Exp1a1.mau;
MAU = [MAU Exp1a2.mau];
MAU = [MAU Exp1a3.mau];
MAU = [MAU Exp1a4.mau];
MAU = [MAU Exp1a5.mau];
MAU = [MAU Exp1a6.mau];
MAU = [MAU Exp1b1.mau];
MAU = [MAU Exp1b2.mau];
MAU = [MAU Exp1b3.mau];
MAU = [MAU Exp1c1.mau];
MAU = [MAU Exp1c2.mau];
MAU = [MAU Exp1c3.mau];
MAU = [MAU Exp1c4.mau];
MAU = [MAU Exp1c5.mau];
MAU = [MAU Exp1c6.mau];
MAU = [MAU Exp1c7.mau];
MAU = [MAU Exp1c8.mau];
MAU = [MAU Exp1c9.mau];
MAU = [MAU Exp1c10.mau];
MAU = [MAU Exp1c11.mau];
MAU = [MAU Exp1c12.mau];
MAU = [MAU Exp1c13.mau];
MAU = [MAU Exp1c14.mau];
MAU = [MAU Exp1c15.mau];
MAU = [MAU Exp1d1.mau];
MAU = [MAU Exp1d2.mau];
MAU = [MAU Exp1d3.mau];
MAU = [MAU Exp1d4.mau];
MAU = [MAU Exp1d5.mau];

% SAU matrix
% (i,j,k) --> i=design, j=epoch, k = attribute
for i = 1:58
    SAU(:,i,1) = SAU_DL;
    SAU(:,i,2) = SAU_LD;
    SAU(:,i,3) = SAU_ET;
    SAU(:,i,4) = SAU_L;
    SAU(:,i,5) = SAU_SA;
    SAU(:,i,6) = SAU_SM;
end
DL_lin = [39 43 44 45 46 50 51 52];
LD_lin = [40 43 44 47 48 50 51 53];
ET_lin = [41 43 45 47 49 50 52 53];
L_lin  = [42 43 46 48 49 51 52 53];
for i = DL_lin
    SAU(:,i,1) = SUNEW_DL;
end
for i = LD_lin
    SAU(:,i,2) = SUNEW_LD;
end
for i = ET_lin
    SAU(:,i,3) = SUNEW_ET;
end
for i = L_lin
    SAU(:,i,4) = SUNEW_L;
end

numEpochs = size(MAU,2);
numAtt    = size(SAU,3);
totalDesigns = size(MAU,1);


% Transitions
numRules = length(Tcost);


% also create attribute weight matrix
AttWeights =[ .3 .3 .3 0 0 .3 .1 .2 .3 .4 .5 .6 .7 .8 .9 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .1 .2 .1 .4 .5 .425 .4 .1 .2 .1 .2 .4 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 .3 ;
.125 0 0 0 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 .125 ;
.175 .175 0 0 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 .175 ;
0 0 0 0 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .05 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 .1 ;
.425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .1 .2 .3 .4 .425 .5 .6 .7 .8 .9 .425 .425 .3 .2 .3 .2 .4 .1 .1 .1 .3 .2 .2 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 .425 ;
0 0 0 0 0 .2 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 
];

